/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.networking;

import com.google.common.collect.Lists;
import fuzs.puzzleslib.api.networking.v3.NetworkHandlerV3;
import java.util.List;

public interface NetworkHandlerRegistry
extends NetworkHandlerV3 {
    public <T extends Record> void registerClientbound(Class<?> var1);

    public <T extends Record> void registerServerbound(Class<?> var1);

    public static abstract class BuilderImpl
    implements NetworkHandlerV3.Builder {
        protected final String modId;
        private final List<Class<?>> clientboundMessages = Lists.newArrayList();
        private final List<Class<?>> serverboundMessages = Lists.newArrayList();
        protected boolean clientAcceptsVanillaOrMissing;
        protected boolean serverAcceptsVanillaOrMissing;

        protected BuilderImpl(String modId) {
            this.modId = modId;
        }

        @Override
        public <T extends Record> NetworkHandlerV3.Builder registerClientbound(Class<T> clazz) {
            if (this.clientboundMessages.contains(clazz)) {
                throw new IllegalStateException("Duplicate message of type %s".formatted(clazz));
            }
            this.clientboundMessages.add(clazz);
            return this;
        }

        @Override
        public <T extends Record> NetworkHandlerV3.Builder registerServerbound(Class<T> clazz) {
            if (this.serverboundMessages.contains(clazz)) {
                throw new IllegalStateException("Duplicate message of type %s".formatted(clazz));
            }
            this.serverboundMessages.add(clazz);
            return this;
        }

        @Override
        public NetworkHandlerV3.Builder clientAcceptsVanillaOrMissing() {
            this.clientAcceptsVanillaOrMissing = true;
            return this;
        }

        @Override
        public NetworkHandlerV3.Builder serverAcceptsVanillaOrMissing() {
            this.serverAcceptsVanillaOrMissing = true;
            return this;
        }

        @Override
        public NetworkHandlerV3 build() {
            NetworkHandlerRegistry networkHandler = this.getHandler();
            this.registerAll(networkHandler);
            return networkHandler;
        }

        protected abstract NetworkHandlerRegistry getHandler();

        private void registerAll(NetworkHandlerRegistry networkHandler) {
            for (Class<?> message : this.clientboundMessages) {
                networkHandler.registerClientbound(message);
            }
            for (Class<?> message : this.serverboundMessages) {
                networkHandler.registerServerbound(message);
            }
        }
    }
}

